/*
 * Decompiled with CFR 0.152.
 */
package com.bosschongsheng.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class BossRespawnConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CONFIG_FILE_NAME = "boss_respawn.json";
    private static BossRespawnConfig instance;
    private final Map<String, BossRespawnRule> rules = new HashMap<String, BossRespawnRule>();
    private Path configPath;

    public static BossRespawnConfig getInstance() {
        if (instance == null) {
            instance = new BossRespawnConfig();
        }
        return instance;
    }

    private BossRespawnConfig() {
        this.loadConfig();
    }

    public Path getConfigPath() {
        if (this.configPath != null) {
            return this.configPath;
        }
        String userDir = System.getProperty("user.dir");
        Path p = Path.of(userDir, "config", "bosschongsheng", CONFIG_FILE_NAME);
        try {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p;
    }

    public void reloadConfig() {
        this.rules.clear();
        this.configPath = null;
        this.loadConfig();
    }

    public List<BossRespawnRule> getRules() {
        return new ArrayList<BossRespawnRule>(this.rules.values());
    }

    public void addRule(BossRespawnRule rule) {
        this.rules.put(rule.structureId, rule);
    }

    public void removeRule(String structureId) {
        this.rules.remove(structureId);
    }

    public BossRespawnRule getRule(String structureId) {
        return this.rules.get(structureId);
    }

    public boolean saveToFile() {
        Path path = this.getConfigPath();
        try {
            JsonObject root = new JsonObject();
            JsonArray arr = new JsonArray();
            for (BossRespawnRule r : this.rules.values()) {
                JsonObject o = new JsonObject();
                o.add("structure", (JsonElement)new JsonPrimitive(r.structureId));
                o.add("triggerItem", (JsonElement)new JsonPrimitive(r.triggerItemId));
                o.add("entity", (JsonElement)new JsonPrimitive(r.entityTypeId));
                arr.add((JsonElement)o);
            }
            root.add("rules", (JsonElement)arr);
            Files.writeString(path, (CharSequence)root.toString(), new OpenOption[0]);
            LOGGER.info("saved {} boss respawn rules to {}", (Object)this.rules.size(), (Object)path);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("save boss_respawn.json failed", (Throwable)e);
            return false;
        }
    }

    private void loadConfig() {
        String userDir = System.getProperty("user.dir");
        Path tryPath = Path.of(userDir, "config", "bosschongsheng", CONFIG_FILE_NAME);
        this.configPath = Files.exists(tryPath, new LinkOption[0]) ? tryPath : Path.of(userDir, "config", "bosschongsheng", CONFIG_FILE_NAME);
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            String jsonContent = Files.readString(this.configPath);
            JsonObject root = JsonParser.parseString((String)jsonContent).getAsJsonObject();
            if (root.has("rules")) {
                JsonArray arr = root.getAsJsonArray("rules");
                for (JsonElement el : arr) {
                    JsonObject o = el.getAsJsonObject();
                    if (!o.has("structure") || !o.has("triggerItem") || !o.has("entity")) continue;
                    String structureId = o.get("structure").getAsString();
                    String triggerItemId = o.get("triggerItem").getAsString();
                    String entityTypeId = o.get("entity").getAsString();
                    this.rules.put(structureId, new BossRespawnRule(structureId, triggerItemId, entityTypeId));
                }
            }
            LOGGER.info("loaded {} boss respawn rules", (Object)this.rules.size());
        }
        catch (IOException e) {
            LOGGER.error("read boss_respawn.json failed", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("parse boss_respawn.json failed", (Throwable)e);
        }
    }

    public static class BossRespawnRule {
        public final String structureId;
        public final String triggerItemId;
        public final String entityTypeId;

        public BossRespawnRule(String structureId, String triggerItemId, String entityTypeId) {
            this.structureId = structureId;
            this.triggerItemId = triggerItemId;
            this.entityTypeId = entityTypeId;
        }
    }
}

